# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history)
    
    # Check if opponent's code is trivial (always C or always D)
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Final rounds (9 and 10): defect
    if current_round >= 8:
        return "D"
    
    # Middle rounds (7 and 8): defect if opponent has defected before
    if current_round >= 6 and any(move == "D" for move in opp_history):
        return "D"
    
    # Early rounds (1-6): cooperate
    return "C"